function Figure2B()
% Running this script produces the plots shown in Figure 2B

C1 = [0.49984 0.58346 0.56571;
      0.57179 0.62691 0.69958;
      0.63075 0.65474 0.63693;
      0.43466 0.40014 0.45073;
      0.29452 0.28465 0.35281;
      0.19966 0.23077 0.20569;      
      0.13776 0.19052 0.16011]*100;
    
mAb = [16845.4847 8843.4257 16826.7243;
       21308.5994 16177.1924 24622.5328;
       36904.6291 16168.1248 31888.0921;
       15892.8206 9775.8698 15298.4899;
       18815.6345 9154.4627 13994.8762;
       1398.2004 988.4649 1427.6803;
       104.4674 81.8408 101.8893];
    
figure
q = [1:7];
dq = [-.1 0 .1];
for k = 1:length(dq)
  plot(q+dq(k),C1(:,k),'s','MarkerFaceColor',[0.7 0.7 0.7],'MarkerEdgeColor',[0.7 0.7 0.7]); hold on;
end
ylim([0 80]);
ylabel('Percent C1-positive particles')
xticks([1:7]);
xticklabels({'CR9501','5C4','Motav.','ADI-19425','101F','ADI-14353','-IgG'})
xtickangle(45);

figure
for k = 1:length(dq)
  semilogy(q+dq(k),mAb(:,k),'s','MarkerFaceColor',[0.7 0.7 0.7],'MarkerEdgeColor',[0.7 0.7 0.7]); hold on;
end
ylim([50 1e5]);
ylabel('mAb intensity (avg. per particle)')
xticks([1:7]);
xticklabels({'CR9501','5C4','Motav.','ADI-19425','101F','ADI-14353','-IgG'})
xtickangle(45);